<?php
/**
 * UTECH SMS Gateway - Configuration File Template
 * 
 * INSTRUCTIONS:
 * 1. Copy this file to config.php
 * 2. Update all values with your actual configuration
 * 3. Keep config.php secure and never commit to version control
 */

// =====================================================
// SECURITY CONFIGURATION
// =====================================================

/**
 * Secret Token for API Authentication
 * 
 * CRITICAL: Change this to a strong, unique random string!
 * 
 * Generate using:
 *   openssl rand -hex 32
 * 
 * Minimum 16 characters, recommended 32+
 * Use same token in Flutter app settings
 */
define('SECRET_TOKEN', 'CHANGE_THIS_TO_YOUR_SECURE_TOKEN_MIN_32_CHARS');

// =====================================================
// DATABASE CONFIGURATION
// =====================================================

/**
 * MySQL Database Connection Settings
 * 
 * Update these with your actual database credentials
 */
define('DB_HOST', 'localhost');           // Database server
define('DB_NAME', 'uukow_data_exchange'); // Database name
define('DB_USER', 'root');                // Database user (change in production!)
define('DB_PASS', '');                    // Database password (set a strong password!)

// =====================================================
// API CONFIGURATION
// =====================================================

/**
 * API Timeout in seconds
 * Adjust based on your network conditions
 */
define('API_TIMEOUT', 30);

/**
 * Enable/Disable Logging
 * Set to false in production if you don't need detailed logs
 */
define('ENABLE_LOGS', true);

/**
 * Log File Path
 * Ensure this directory exists and is writable
 */
define('LOG_FILE', __DIR__ . '/logs/gateway.log');

// =====================================================
// OPERATOR INTEGRATION
// =====================================================

/**
 * Use Operator API for Provisioning
 * 
 * If you have direct API access to operators (Hormuud, Somnet, Somtel),
 * set this to true and configure API endpoints below.
 * 
 * If false, will fall back to SMS gateway method.
 */
define('USE_OPERATOR_API', false);

/**
 * Operator API Endpoints
 * 
 * Configure these if USE_OPERATOR_API is true
 * Contact your operator for API documentation and credentials
 */
define('HORMUUD_API_URL', 'https://api.hormuud.com/provision');
define('HORMUUD_API_KEY', 'your-hormuud-api-key');
define('HORMUUD_API_SECRET', 'your-hormuud-api-secret');

define('SOMNET_API_URL', 'https://api.somnet.com/provision');
define('SOMNET_API_KEY', 'your-somnet-api-key');
define('SOMNET_API_SECRET', 'your-somnet-api-secret');

define('SOMTEL_API_URL', 'https://api.somtel.com/provision');
define('SOMTEL_API_KEY', 'your-somtel-api-key');
define('SOMTEL_API_SECRET', 'your-somtel-api-secret');

// =====================================================
// SMS GATEWAY CONFIGURATION (Fallback)
// =====================================================

/**
 * SMS Gateway Settings
 * 
 * Used when USE_OPERATOR_API is false or as fallback
 * Configure your SMS gateway provider details here
 */
define('SMS_GATEWAY_URL', 'http://localhost/sms_gateway/send.php');
define('SMS_GATEWAY_USERNAME', 'your_username');
define('SMS_GATEWAY_PASSWORD', 'your_password');
define('SMS_GATEWAY_SENDER_ID', 'UTECH');  // Your sender ID

// =====================================================
// BUNDLE MAPPING
// =====================================================

/**
 * Payment Amount to Data Bundle Mapping
 * 
 * Maps payment amounts to data bundle sizes
 * 
 * Format: 'amount' => 'bundle_size'
 * 
 * Add/modify entries based on your pricing
 * Both decimal and integer formats are supported
 */
$BUNDLE_MAPPING = [
    // 1 Dollar packages
    '1.00' => '1GB',
    '1' => '1GB',
    
    // 2 Dollar packages
    '2.00' => '2GB',
    '2' => '2GB',
    
    // 3 Dollar packages
    '3.00' => '3GB',
    '3' => '3GB',
    
    // 5 Dollar packages
    '5.00' => '5GB',
    '5' => '5GB',
    
    // 10 Dollar packages
    '10.00' => '10GB',
    '10' => '10GB',
    
    // 20 Dollar packages
    '20.00' => '20GB',
    '20' => '20GB',
    
    // Add more mappings as needed
    // '0.50' => '500MB',
    // '15.00' => '15GB',
];

// =====================================================
// OPERATOR SHORTCODES
// =====================================================

/**
 * Operator USSD/Shortcode Commands
 * 
 * Used for SMS gateway provisioning method
 * Format varies by operator - update based on actual operator codes
 * 
 * Example formats:
 *   Hormuud: *712*BUNDLE# (where BUNDLE = 1, 2, 3, etc.)
 *   Somnet: *151*BUNDLE#
 *   Somtel: *888*BUNDLE#
 */
$OPERATOR_SHORTCODES = [
    'hormuud' => '*712*',
    'somnet' => '*151*',
    'somtel' => '*888*',
];

// =====================================================
// PAYMENT SENDER IDENTIFIERS
// =====================================================

/**
 * Payment SMS Sender Identifiers
 * 
 * Used to identify which operator sent the payment SMS
 * These are the sender names that appear in SMS messages
 */
$PAYMENT_SENDERS = [
    'hormuud' => 'Hormuud',
    'somnet' => 'Somnet',
    'somtel' => 'Somtel',
];

// =====================================================
// TIMEZONE CONFIGURATION
// =====================================================

/**
 * Application Timezone
 * 
 * Set to your local timezone
 * List: https://www.php.net/manual/en/timezones.php
 */
date_default_timezone_set('Africa/Mogadishu');

// =====================================================
// AUTO-SETUP
// =====================================================

/**
 * Create logs directory if it doesn't exist
 */
if (!file_exists(__DIR__ . '/logs')) {
    mkdir(__DIR__ . '/logs', 0755, true);
}

// =====================================================
// VALIDATION
// =====================================================

/**
 * Validate critical configuration
 */
if (SECRET_TOKEN === 'CHANGE_THIS_TO_YOUR_SECURE_TOKEN_MIN_32_CHARS') {
    error_log('WARNING: Using default SECRET_TOKEN. Please change it in config.php!');
}

if (strlen(SECRET_TOKEN) < 16) {
    error_log('WARNING: SECRET_TOKEN is too short. Use at least 16 characters!');
}

if (DB_PASS === '' && DB_HOST === 'localhost') {
    error_log('WARNING: Database password is empty. Set a strong password in production!');
}

// =====================================================
// NOTES
// =====================================================

/**
 * IMPORTANT SECURITY NOTES:
 * 
 * 1. Never commit config.php to version control
 * 2. Use .gitignore to exclude config.php
 * 3. Set restrictive file permissions: chmod 600 config.php
 * 4. Use HTTPS only in production
 * 5. Change default database credentials
 * 6. Generate strong random SECRET_TOKEN
 * 7. Keep backups of your configuration
 * 8. Rotate secrets regularly (every 3-6 months)
 * 
 * TROUBLESHOOTING:
 * 
 * - Check logs/gateway.log for detailed error messages
 * - Verify database connection with: php -r "new mysqli('localhost', 'user', 'pass', 'db');"
 * - Test API endpoint with curl (see API_TESTING.md)
 * - Ensure logs directory is writable: chmod 755 logs
 * 
 * PERFORMANCE:
 * 
 * - Enable PHP OPcache in production
 * - Use connection pooling for high volume
 * - Consider Redis for caching if needed
 * - Monitor database query performance
 * - Archive old logs regularly
 */

